<?php
/**
 * Plugin Name: WhatsApp Join Group Button
 * Description: Adds a WhatsApp icon at bottom left with a hover message.
 * Version: 1.0
 * Author: Divine Asiedu
 */

add_action('wp_footer', 'wjg_add_whatsapp_button');

function wjg_add_whatsapp_button() {
    ?>
    <style>
        .whatsapp-container {
            position: fixed;
            bottom: 20px;
            left: 20px;
            z-index: 9999;
            display: flex;
            align-items: center;
            cursor: pointer;
        }

        .whatsapp-message {
            background-color: #25D366;
            color: white;
            padding: 10px 15px;
            border-radius: 20px;
            margin-right: 10px;
            font-size: 14px;
            white-space: nowrap;
            opacity: 0;
            transform: translateX(-10px);
            transition: all 0.3s ease;
        }

        .whatsapp-container:hover .whatsapp-message {
            opacity: 1;
            transform: translateX(0);
        }

        .whatsapp-icon {
            width: 50px;
            height: 50px;
            background-color: #25D366;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 2px 8px rgba(0,0,0,0.2);
        }

        .whatsapp-icon img {
            width: 24px;
            height: 24px;
        }
    </style>

    <div class="whatsapp-container" onclick="window.open('https://chat.whatsapp.com/BnEfPjk2n9K44wqhonejiG', '_blank')">
        <div class="whatsapp-message">Click to join our WhatsApp Group</div>
        <div class="whatsapp-icon">
            <img src="https://img.icons8.com/ios-filled/50/ffffff/whatsapp.png" alt="WhatsApp" />
        </div>
    </div>
    <?php
}
